<?php
/**
 * NYLTA — Authorization PDF (mPDF)
 * Populates your HTML with GET vars, then downloads a PDF.
 *
 * Example at bottom of this message.
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

require_once __DIR__ . '/vendor/autoload.php';

// -------- Helpers
function h($v) { return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
function money($v) {
    if ($v === '' || $v === null) return '$0.00';
    $n = preg_replace('/[^\d.\-]/', '', (string)$v);
    if ($n === '' || !is_numeric($n)) $n = 0;
    return '$' . number_format((float)$n, 2);
}

// -------- Inputs (URL params)
$name           = $_GET['name']          ?? '';
$email          = $_GET['email']         ?? '';
$llcname        = $_GET['llcname']       ?? '';
$fictitious_name          = $_GET['fictitious_name']         ?? '';
$nydos          = $_GET['nydos']         ?? '';
$ein            = $_GET['ein']           ?? '';
$ip             = $_GET['ip']            ?? '';
$street_address            = $_GET['street_address']           ?? '';
$city            = $_GET['city']           ?? '';
$country            = $_GET['country']           ?? '';
$state            = $_GET['state']           ?? '';
$zip            = $_GET['zip']           ?? '';
$amount         = $_GET['amount']        ?? '0';
$Date           = $_GET['Date']          ?? date('m/d/Y');
$time           = $_GET['time']          ?? date('H:i');
$seconds        = $_GET['seconds']       ?? date('s');

// Optional: require at least a name
if ($name === '') {
    die('Error: "name" is required.');
}

// logo (top)
$logoUrl = 'https://certificate.nylta.com/icons/logo.png';

// -------- HTML/CSS (your template + variables)
$html = '
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>authorization</title>
    <style>
        @page {
            background-color: #fff;
            margin: 20px 0;
        }

        body {
            font-family: "poppins", sans-serif;
            line-height: 1.5;
            color: #000;
        }

        h1, h2, h3 {
            font-family: "librebaskerville", serif;
        }

        a {
            color: #273a68;
            text-decoration: underline;
        }
        .authorization_banner {
            background: url("https://storage.googleapis.com/msgsndr/fXXJzwVf8OtANDf2M4VP/media/6911d3fd9ccab370d8a0f33f.jpg") no-repeat center/100% auto;
        }
    </style>
</head>
<body>
<div class="authorization_header" style="width: 100%;padding: 0 0 20px;text-align: center;">
    <img class="logo" style="width: 200px;" src="'.h($logoUrl).'"/>
</div>
<div class="authorization_banner"
     style="width: 100%;padding: 40px 20px;text-align: center;">
    <h1 class="authorization-title" style="font-size: 24px; color:#fff; font-weight: bold; margin: 0 0 8px;">Client Service Agreement & Authorization</h1>
    <p style="font-size: 16px;color: #fff;margin: 0;">Review this Client Service Agreement & Authorization carefully. By using NYLTA.com™, you agree to these terms, which define our role and your responsibilities under the NYLTA filing process.</p>
</div>
<div class="authorization_body" style="width: 100%;padding: 40px 20px 0;">
    <h3 style="font-size: 18px;margin: 0;padding-right: 40px">Effective Date: January 1, 2026<br>
        Business Name: NYLTA.com™ (DBA of New Way Enterprise LLC)</h3>
    <p style="font-size: 14px;margin: 0;">Note: NYLTA.com™ is currently accepting pre-registrations and Compliance<br>
    Review & Monitoring enrollments in advance of the New York LLC Transparency Act’s effective date and during periods of evolving regulatory guidance. This Agreement governs services that may include compliance review, monitoring, filing preparation, and filing facilitation, which are performed only when legally required, technically available, and expressly authorized by the Client.<br>
    Information submitted during pre-registration or monitoring may be securely retained for compliance purposes; however, no filing will be submitted unless and until expressly authorized by the Client.</p>
    <br><br>
    <h2 style="font-size: 20px;font-weight:bold;margin: 0 0 8px;">1. Agreement to Terms</h2>
    <p style="font-size: 14px;margin: 0;">By creating an account or submitting information through the NYLTA.com™ platform, you (“Client,” “'.h($name).'”) agree to this Client Service Agreement & Authorization (“Agreement”). NYLTA.com™ (“Platform,” “we,” “our”) is operated by New Way Enterprise LLC, a Florida limited liability company.
        <br><br>
        This Agreement governs your use of our software-as-a-service (SaaS) platform, which is designed to assist New York LLCs with their obligations under the New York LLC Transparency Act (NYLTA).
        <br><br>
        Submission of information through the Platform does not constitute a filing with the New York Department of State. Filing facilitation occurs <strong>only when legally required, technically available, and expressly authorized by the Client.</strong></p>
    <hr>
    <h2 style="font-size: 20px;font-weight:bold;margin: 0 0 8px;">2. Overview of Services</h2>
    <p style="font-size: 14px;margin: 0;">NYLTA.com™ is a private, non-government compliance technology platform that provides secure, cloud-based workflows to support compliance review, regulatory monitoring, filing preparation, and filing facilitation related to the New York LLC Transparency Act (“NYLTA”).
        <br>
        The Platform enables Clients to:
    </p>
    <ul style="margin: 0 0 0 12px;padding: 0 0 0 12px;font-size: 14px;">
        <li>Input and store entity and ownership information through guided forms;</li>
        <li>Receive compliance review and ongoing monitoring based on current guidance issued by the New York Department of State</li>
        <li>Prepare beneficial ownership disclosures or exemption attestations when applicable;</li>
        <li>Authorize submission of required data to the New York Department of State when filing is legally required; and</li>
        <li>Access records related to authorized filings.</li>
    </ul>
    <p style="font-size: 14px;margin: 0;">NYLTA.com™ provides technology and facilitation services only. We are not a government agency and do not provide legal or tax advice. Responsibility for the accuracy and completeness of all information remains solely with the Client.</p>
    <hr>
    <h2 style="font-size: 20px;font-weight:bold;margin: 0 0 8px;">3. Service Commencement</h2>
    <p style="font-size: 14px;margin: 0;">NYLTA.com™ may provide pre-registration, compliance review, and Compliance Review & Monitoring services prior to and after the effective date of the New York LLC Transparency Act, depending on current regulatory guidance.
    <br><br>
    Filing preparation and filing facilitation services are performed only when filing is legally required under applicable guidance, technically available, and expressly authorized by the Client.
    <br><br>
    Information submitted prior to filing authorization may be retained for compliance review and monitoring purposes and does not result in automatic submission.
    </p>
    <hr>
    <h2 style="font-size: 20px;font-weight:bold;margin: 0 0 8px;">4. Client Authorization</h2>
    <p style="font-size: 14px;margin: 0;">By providing authorization through the Platform, the Client:</p>
    <ul style="margin: 0 0 0 12px;padding: 0 0 0 12px;font-size: 14px;">
        <li>Confirms they are legally authorized to act on behalf of the entity; Authorizes NYLTA.com™ to use its technology platform to perform compliance review, monitoring, and — if legally required and expressly authorized — to facilitate filing with the New York Department of State;</li>
        <li>Acknowledges and agrees to the following pricing structure, as disclosed at checkout:
        Compliance Review & Monitoring: $249.00, covering up to twelve (12) months of monitoring;<br>
        Filing Services (if required): $398.00 total, which includes Compliance Review & Monitoring; or<br>
        If Compliance Review & Monitoring has already been purchased, only the remaining balance of $149.00 will be due at the time filing is authorized; and</li>
        <li>Acknowledges that filing-related fees are non-refundable once a filing has been submitted or formally attempted.</li>
    </ul>
    <p style="font-size: 14px;margin: 0;">NYLTA.com™ does not automatically submit filings or charge filing fees without Client authorization.</p>
    <hr>
    <h2 style="font-size: 20px;font-weight:bold;margin: 0 0 8px;">5. Client Responsibilities</h2>
    <p style="font-size: 14px;margin: 0;">You agree to:</p>
    <ul style="margin: 0 0 0 12px;padding: 0 0 0 12px;font-size: 14px;">
        <li>Provide accurate, complete, and current information through the Platform;</li>
        <li>Review all information for accuracy prior to authorizing any filing;</li>
        <li>Respond promptly to requests for clarification or additional information; and</li>
        <li>Maintain ongoing compliance with NYLTA obligations beyond any initial filing.</li>
    </ul>
    <p style="font-size: 14px;margin: 0;">The Client further acknowledges and agrees that:</p>
    <ul style="margin: 0 0 0 12px;padding: 0 0 0 12px;font-size: 14px;">
        <li>Compliance Review & Monitoring services are offered for a fee of $249.00;</li>
        <li>Monitoring services may be provided even if no filing is ultimately required;</li>
        <li>Filing services are subject to separate authorization and fees as described in this Agreement, with the total filing fee not to exceed $398.00; and</li>
        <li>NYLTA.com™ is not responsible for penalties, delays, or consequences resulting from inaccurate, incomplete, or untimely information provided by the Client.</li>
    </ul>
    <hr>
    <h2 style="font-size: 20px;font-weight:bold;margin: 0 0 8px;">6. Limitations of Service</h2>
    <ul style="margin: 0 0 0 12px;padding: 0 0 0 12px;font-size: 14px;">
        <li>We cannot guarantee acceptance or turnaround times of the New York Department of State.</li>
        <li>We do not correct, alter, or validate legal eligibility of your entity.</li>
        <li>Platform use does not create an attorney-client or advisor relationship.</li>
    </ul>
    <hr>
    <h2 style="font-size: 20px;font-weight:bold;margin: 0 0 8px;">6.1. No Automatic Filing</h2>
    <p style="font-size: 14px;margin: 0;">NYLTA.com™ does not automatically submit filings to any government agency. Filing facilitation occurs only when legally required, technically available, and expressly authorized by the Client.</p>
    <hr>
    <h2 style="font-size: 20px;font-weight:bold;margin: 0 0 8px;">7. Refunds</h2>
    <p style="font-size: 14px;margin: 0;"><strong>Monitoring Services:</strong><br>The $249.00 Compliance Review & Monitoring fee is refundable only if requested within thirty (30) days of the purchase date and before substantive monitoring services commence. After thirty (30) days from purchase, or once monitoring services have commenced, monitoring fees are non-refundable.
    <br><br>
    <strong>Filing Services:</strong><br>Filing-related fees are refundable only if requested prior to submission or attempted submission to the New York Department of State. Once submission is attempted, services are deemed rendered and non-refundable.</p>
    <hr>
    <h2 style="font-size: 20px;font-weight:bold;margin: 0 0 8px;">8. Governing Law</h2>
    <p style="font-size: 14px;margin: 0;">This Agreement is governed by the laws of the State of Florida (where the platform is headquartered), without regard to conflict-of-law rules.</p>
    <hr>
    <h2 style="font-size: 20px;font-weight:bold;margin: 0 0 8px;">9. Acknowledgment</h2>
    <p style="font-size: 14px;margin: 0;">By using the NYLTA.com™ SaaS platform, you acknowledge and agree that:</p>
    <ul style="margin: 0 0 0 12px;padding: 0 0 0 12px;font-size: 14px;">
        <li>We are an independent compliance technology provider, not the New York Department of State;</li>
        <li>You retain responsibility for the accuracy of your data;</li>
        <li>All services are delivered through our online software platform.</li>
    </ul>
    <hr>
    <h2 style="font-size: 24px;font-weight:bold;margin: 0 0 8px;">Customer Details</h2>
    <p style="font-size: 14px;margin: 0;"><strong>Full Name:</strong> '.h($name).'
        <br>
        <strong>Email Address:</strong> '.h($email).'
        <br>
        <strong>Legal Business Name:</strong> '.h($llcname).'
        <br>
        <strong>Fictitious Name (DBA):</strong> '.h($fictitious_name).'
        <br>
        <strong>NY DOS ID Number:</strong> '.h($nydos).'
        <br>
        <strong>EIN / Federal Tax ID:</strong> '.h($ein).'
        <br>
        <strong>IP Address:</strong> '.h($ip).'
        <br>
        <strong>Street Address:</strong> '.h($street_address).'
        <br>
        <strong>City:</strong> '.h($city).'
        <br>
        <strong>Country:</strong> '.h($country).'
        <br>
        <strong>State:</strong> '.h($state).'
        <br>
        <strong>Zip Code:</strong> '.h($zip).'
        </p>
    <hr>
    <h2 style="font-size: 24px;font-weight:bold;margin: 0 0 8px;">ID Verification</h2>
    <p style="font-size: 14px;margin: 0;"><strong>EIN / Federal Tax ID:</strong> '.h($ein).'</p>
    <br>
    <p style="font-size: 14px;margin: 0;">I authorize NYLTA to debit my bank account or debit/credit card for a one time
        payment in the amount of '.money($amount).' on '.h($Date).'. I also authorize
        NYLTA
        to debit or credit my account to correct any errors. If my payment is returned unpaid, I authorize NYLTA to make
        a one time electronic fund transfer from my account to collect a return
        fee if applicable.
        <br><br>
        I understand that this payment will be authorized by NYLTA on '.h($Date).'. Due to the speed
        of
        electronic payment processing, I may not cancel the payment after authorizing this payment.
        <br><br>
        By clicking "Proceed", I '.h($name).' agree and authorize this payment and confirm that I am an owner/joint
        owner or authorized user of the bank account or debit/credit card identified, and consent to sign this
        authorization
        electronically.</p>
    <hr>
    <h2 style="font-size: 24px;font-weight:bold;margin: 0 0 8px;">'.h($name).'</h2>
    <p style="font-size: 14px;margin: 0;"><strong>IP Address:</strong> '.h($ip).'
        <br>
        <strong>Authorization date:</strong> '.h($Date).'T'.h($time).':'.h($seconds).'
    </p>
</div>
</body>
</html>
';

$defaultConfig = (new Mpdf\Config\ConfigVariables())->getDefaults();
$fontDirs = $defaultConfig['fontDir'];

$defaultFontConfig = (new Mpdf\Config\FontVariables())->getDefaults();
$fontData = $defaultFontConfig['fontdata'];

// -------- mPDF
$mpdf = new \Mpdf\Mpdf([
    'mode' => 'utf-8',
    'format' => 'A4',
    'margin_top' => 0,
    'margin_bottom' => 0,
    'margin_left' => 0,
    'margin_right' => 0,
    'fontDir' => array_merge($fontDirs, [__DIR__ . '/fonts']),
    'fontdata' => $fontData + [
            'poppins' => [
                'R' => 'Poppins-Regular.ttf',
                'B' => 'Poppins-Bold.ttf',
            ],
            'poppinsmedium' => [ // 👈 new font alias
                'R' => 'Poppins-Medium.ttf',
            ],
            'librebaskerville' => [
                'R' => 'LibreBaskerville-Regular.ttf',
                'B' => 'LibreBaskerville-Bold.ttf',
            ],
        ],
    'default_font' => 'poppins',
]);

$mpdf->WriteHTML($html);

// download
$filename = 'Client Service Agreement & Authorization_'.preg_replace('/[^A-Za-z0-9_-]/', '', $name).'_'.date('Ymd').'.pdf';
$mpdf->Output($filename, 'D');
