<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/vendor/autoload.php';

/* --------------------------------------------------
| 1. URL PARAMETERS
-------------------------------------------------- */
$full_name       = $_GET['full_name']       ?? '';
$email           = $_GET['email']           ?? '';
$signature   = $_GET['signature']   ?? '';
$signature_date  = $_GET['signature_date']  ?? '';
$time_hour = $_GET['time_hour'] ?? '';
$time_minute = $_GET['time_minute'] ?? '';
$time_second = $_GET['time_second'] ?? '';
$time_clock = $_GET['time_clock'] ?? '';
$ip_address      = $_GET['ip']              ?? '';
$year      = $_GET['year']              ?? '';

$doc_title = "Service Completion & Acceptance Certificate - {$full_name}";

/* --------------------------------------------------
| 2. LOCAL ASSET PATHS (ABSOLUTE)
-------------------------------------------------- */
$basePath   = __DIR__;
$logo       = $basePath . '/logo.png';
$bannerBg   = $basePath . '/banner-bg.png';
$contentBg  = $basePath . '/content-bg.jpg';

/* --------------------------------------------------
| 3. HTML (YOUR LAYOUT – UNCHANGED)
-------------------------------------------------- */
$html = '
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: "Poppins", Arial, sans-serif;
        }
        body {
            background: #f1f3f6;
            color: #1c1c1c;
        }
    </style>
</head>
<body>
    <header style="background:#0d123d;padding:20px 0;">
        <div style="text-align: center;">
            <img src="'.$logo.'" style="width:200px;">
        </div>
    </header>
    <section style="background:url(\''.$bannerBg.'\') no-repeat center/100% 100%;padding:40px 0;text-align:center;">
        <h1 style="color:#ffffff;font-size:32px;font-weight:bold;margin:0;">
            RewardLion Terms of Service
        </h1>
    </section>
    <main style="background:#ffffff;">
        <section style="padding:10px;">
            <div style="width:100%;background: #F5F5F5;padding:20px;border:1px solid #ecf0f6;">
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;"><strong>RewardLion (“RewardLion”)</strong> is an online marketing and technology solutions firm that works with clients across the nation. Our objective is to provide targeted digital marketing, automation, and business growth solutions for our clients through platforms such as Google, Facebook, and related digital channels. By agreeing to partner with RewardLion, you are also agreeing to the following terms and conditions.</p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">Privacy Statement</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;">RewardLion will never sell, trade, or otherwise disclose personally identifiable information to anyone. We will not share your email address or contact information with any other company. We may use third-party advertising or technology service providers to perform services on our behalf. These companies may employ cookies, tracking pixels, or action tags to measure advertising effectiveness and system performance. Any information collected by these third parties is anonymous and does not personally identify you.</p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">Warranties</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;">THE INFORMATION AND SERVICES THAT REWARDLION PROVIDES ARE OFFERED ON AN “AS IS” AND “AS AVAILABLE” BASIS WITH <strong>NO REFUNDS</strong> AND WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY, OR FITNESS FOR A PARTICULAR PURPOSE. NO ADVICE OR INFORMATION GIVEN BY REWARDLION, ITS AFFILIATES, OR THEIR RESPECTIVE EMPLOYEES SHALL CREATE ANY WARRANTY HEREUNDER.</p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">Subscription Details</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;">This Order confirms the arrangement made between you and a RewardLion marketing specialist to provide the agreed-upon service(s), as authorized by you and, when applicable, recorded. Unless explicitly contradicted by this Order Confirmation, the recorded agreement remains in full force and effect.<br>
                All services are provided on a month-to-month basis unless otherwise agreed to in writing. Billing begins on the date you first establish participation and will continue automatically on the monthly anniversary date via the payment method on file.<br>
                Billing descriptors will reflect RewardLion on your banking or credit card statements. <strong>RewardLion</strong> guarantees that your monthly payment will <strong>not increase without your express consent</strong>, and your pricing will remain fixed for the lifetime of your active account.</p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">Licenses</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;">You hereby grant RewardLion a non-exclusive, irrevocable, royalty-free, worldwide license under all copyrights, trademarks, patents, trade secrets, privacy and publicity rights, and other intellectual property rights you own or control, solely as necessary to provide marketing, automation, traffic direction, and related services on your behalf.</p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">General Terms</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;"><strong>Authority to Bind:</strong><br>
                No employee, contractor, or specialist of RewardLion or any of its divisions is authorized to enter into or modify any binding agreement via email or verbal communication without approval from an authorized Account Manager.</p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">Governing Law</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;">This Agreement shall be governed by and construed in accordance with the laws of the <strong>State of Washington</strong>, without regard to conflict-of-law principles. The parties agree that exclusive jurisdiction and venue for any dispute shall lie in the courts located in <strong>Clark County, Washington.</strong></p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">Waiver</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;">Failure to insist upon strict compliance with any term or condition of this Agreement shall not constitute a waiver of such term or condition, nor shall any waiver or relinquishment of any right or power under this Agreement at any one or more times be deemed a waiver or relinquishment of such right or power at any other time.</p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">Billing Policy</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;">You are responsible for keeping all account information current, including contact details, subscribed websites, and payment information.<br>
                If payment fails for any reason, services may remain active for up to <strong>30 days</strong> while RewardLion attempts to obtain updated payment information. This does not relieve you of your obligation to pay all outstanding balances. Accounts not brought current within 30 days may be suspended immediately and turned over to a collections agency.</p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">Cancellation Policy</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;">All cancellation requests must be received <strong>at least three (3) business days prior to the monthly anniversary date</strong>. Cancellation requests must be submitted by email or directly through https://rewardlion.com/.<br>
                If notice of cancellation is not provided within this time frame, RewardLion cannot prevent an automatic charge and you will be billed for an additional month.</p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">No Refund Policy</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;"><strong>REWARDLION DOES NOT PROVIDE REFUNDS.</strong></p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">Client Identification</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;"><strong>Full Name: </strong>'.$full_name.'<br>
                <strong>Email Address: </strong>'.$email.'</p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">Transaction Reference</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;">This certificate confirms completion and acceptance of the AI Ads Pro DFY onboarding and setup services, purchased on '.$signature_date.' in the amount of $1,000 USD, and the AI Ads Pro software subscription billed at $297/month, processed via Stripe.</p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">DFY Service Acceptance</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;">The client confirms that the DFY onboarding and setup services have been fully delivered, reviewed, and accepted. The client acknowledges that the DFY setup fee is non-refundable once services begin, as agreed at the time of purchase.</p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">Software Subscription Acknowledgment</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;">The client confirms access to the AI Ads Pro software platform and acknowledges that the subscription is billed on a recurring monthly basis. The client understands that subscription fees are non-refundable once billed and that cancellation must be completed prior to the next billing cycle to avoid future charges.</p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">Chargeback Acknowledgment</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;">The client acknowledges that disputes or chargebacks filed in place of the agreed cancellation or support process are not valid grounds for refunds under the Terms and Conditions.</p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">Terms Re-Acceptance</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;">The client confirms they have read and agree to the Terms and Conditions, Privacy Policy, and billing policies available at<br>
                https://rewardlion.net/terms-and-conditions.</p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">Completion Timestamp</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;"><strong>Date completed: </strong>'.$signature_date.'<br>
                <strong>Time: </strong>'.$time_hour.':'.$time_minute.':'.$time_second.' '.$time_clock.'</p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">Signature</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;"><strong>Digital signature: </strong><a href="'.$signature.'" style="color:#0d123d; text-decoration: underline;" target="_blank">View Digital Signature</a><br>
                <strong>Signature date: </strong>'.$signature_date.'<br>
                <strong>IP address: </strong>'.$ip_address.'</p>
                <h2 style="font-size:20px;color:#0d123d;margin:0;">Issuer Information</h2>
                <p style="font-size:14px;line-height:1.4;color:#686868;margin:0 0 16px;">RewardLion<br>
                www.rewardlion.com<br>
                billing@rewardlion.com</p>
            </div>
        </section>
    </main>
    <footer style="background:#0d123d;color:#ffffff;text-align:center;padding:16px 10px;">
        <p style="font-size:14px;color:#28a9e0;margin: 0 0 16px;"><a href="https://rewardlion.net/privacy-policy" target="_blank" style="color:#28a9e0;text-decoration: none;">Privacy Policy</a> | <a href="https://rewardlion.net/terms-and-conditions" target="_blank" style="color:#28a9e0;text-decoration: none;">Terms of Use</a> | <a href="https://rewardlion.net/privacy-security-commitment" target="_blank" style="color:#28a9e0;text-decoration: none;">Privacy & Security</a> | <a href="https://rewardlion.net/affiliate-agreement" target="_blank" style="color:#28a9e0;text-decoration: none;">Affiliate Agreement</a> | <a href="https://rewardlion.net/app-policy" target="_blank" style="color:#28a9e0;text-decoration: none;">App Policy</a> | <a href="https://rewardlion.net/ai-terms" target="_blank" style="color:#28a9e0;text-decoration: none;">AI Terms</a></p>
        <p style="font-size:14px;margin:0;">© All Rights Reserved RewardLion Powered by <a href="https://rewardlion.net/" target="_blank" style="color:#ffffff;text-decoration: none;">RewardLion AI Powered Solutions</a> '.$year.'</p>
    </footer>
</body>
</html>
';

/* --------------------------------------------------
| 4. mPDF CONFIG
-------------------------------------------------- */

$defaultConfig = (new Mpdf\Config\ConfigVariables())->getDefaults();
$fontDirs = $defaultConfig['fontDir'];

$defaultFontConfig = (new Mpdf\Config\FontVariables())->getDefaults();
$fontData = $defaultFontConfig['fontdata'];

$mpdf = new \Mpdf\Mpdf([
    'mode' => 'utf-8',
    'format' => 'A4',
    'orientation' => 'P', // PORTRAIT
    'margin_top' => 0,
    'margin_bottom' => 0,
    'margin_left' => 0,
    'margin_right' => 0,
    'fontDir' => array_merge($fontDirs, [$basePath . '/fonts']),
    'fontdata' => $fontData + [
            'poppins' => [
                'R' => 'Poppins-Regular.ttf',
                'B' => 'Poppins-Bold.ttf',
            ],
            'poppinsmedium' => [
                'R' => 'Poppins-Medium.ttf',
            ],
        ],
    'default_font' => 'poppins',
]);

$mpdf->SetTitle($doc_title);
$mpdf->WriteHTML($html);

/* --------------------------------------------------
| 5. OUTPUT
-------------------------------------------------- */
$filename = preg_replace('/[^A-Za-z0-9_-]/', '', $full_name);
$mpdf->Output("Service Completion Acceptance - {$filename}.pdf", 'D');