<?php
/**
 * NYLTA — Invoice PDF (mPDF)
 * Usage example:
 *   /invoice.php?date=10/29/2025&name=Tanaka%20Michele%20Cross&address=17137%20Sea%20Skiff%20Way&city=Dumfries&state=Virginia&zip=22026&country=USA&email=tmc%40tmcrossbookkeeping.com&llcname=TM%20Cross%20Bookkeeping,%20LLC&amount=349&description=BOIR%20Filing&quantity=1
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

require_once __DIR__ . '/vendor/autoload.php';

// -------- Helpers
function h($v) { return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
function money($v) {
    if ($v === '' || $v === null) return '$0.00';
    $n = preg_replace('/[^\d.\-]/', '', (string)$v);
    if ($n === '' || !is_numeric($n)) $n = 0;
    return '$' . number_format((float)$n, 2);
}

// -------- Inputs
$processedDate = $_GET['date'] ?? date('m/d/Y');

$name     = $_GET['name']     ?? '';
$address  = $_GET['address']  ?? '';
$city     = $_GET['city']     ?? '';
$state    = $_GET['state']    ?? '';
$zip      = $_GET['zip']      ?? '';
$country  = $_GET['country']  ?? '';
$email    = $_GET['email']    ?? '';
$llcname  = $_GET['llcname']  ?? '';
$qty      = (int)($_GET['quantity'] ?? 1);
$amount   = $_GET['amount']   ?? '0';

if ($name === '' || $address === '') {
    die('Error: "name" and "address" are required.');
}

// logo (top-right)
$logoUrl = 'https://certificate.nylta.com/icons/logo.png';

// box text under Description (as in screenshot)
$desc2 = $llcname ? $llcname : '';

// -------- HTML/CSS
$html = '
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title>Invoice</title>
  <style>
    @page {
      margin: 36px;
      border: solid 2px #DDDDDD;
      background-color: #fff;
    }

    body {
      font-family: "poppins", sans-serif;
      line-height: 1.5;
      color: #000;
    }

    a {
      color: #273a68;
      text-decoration: underline;
    }

    .invoice_footer table {
      border: solid #000;
      border-width: 2px 0 2px 2px;
    }

    .invoice_footer table th {
      background: #273a68;
      color: #fff;
      padding: 14px;
      font-size: 20px;
      text-align: center;
      border: solid #000;
      border-width: 0 2px 2px 0;
    }

    .invoice_footer table th:last-child {
      border-width: 0 0 2px 0;
    }

    .invoice_footer table td {
      padding: 20px 10px;
      font-size: 18px;
      text-align: center;
      border: solid #000;
      border-width: 0 2px 0 0;
    }

    .invoice_footer table td:last-child {
      border-width: 0;
    }
  </style>
</head>
<body>
<div class="invoice_header"
     style="width: 100%;display: flex; flex-direction: row;border-bottom: 4px solid #000;padding-bottom: 36px;">
  <div align="left" style="width: 60%;float: left;">
    <h1 class="invoice-title" style="font-size: 30px;font-weight: bold; margin: 0 0 8px;">Invoice</h1>
    <p style="font-size: 20px;color: #333;margin: 0;">Processed Date: '.h($processedDate).'</p>
  </div>
  <div style="width: 40%;float: left;text-align: right;">
    <img class="logo" style="width: 200px;" src="'.h($logoUrl).'"/>
  </div>
</div>
<div class="invoice_body" style="width: 100%;display: flex; flex-direction: row;padding: 60px 0;">
  <div align="left" style="width: 60%;float: left;">
    <h2 style="font-size: 20px;font-weight:bold;margin: 0 0 8px;">'.h($name).'</h2>
    <p style="font-size: 18px;margin: 0;padding-right: 40px">'.h($address).', '.h(trim($city.($city&&$state?', ':'').$state.', '.$zip)).' '.($country ? ' '.h($country).' ' : '').' '.($email ? '</p>
    <a style="font-size: 18px;margin: 0;" href="mailto:'.h($email).'" target="_blank">'.h($email).'</a>' : '').'
  </div>
  <div style="width: 40%;float: left;">
    <h2 style="font-size: 20px;font-weight:bold;margin: 0 0 8px;">NYLTA.com</h2>
    <div><a style="font-size: 18px;margin: 0;" href="mailto:support@nylta.com" target="_blank">support@nylta.com</a>
    </div>
    <div><a style="font-size: 18px;margin: 0;" href="https://www.nylta.com" target="_blank">www.nylta.com</a></div>
  </div>
</div>
<div class="invoice_footer" style="width: 100%;">
  <table cellspacing="0" cellpadding="0" style="width: 100%;">
    <thead>
    <tr>
      <th class="left">Description</th>
      <th>Quantity</th>
      <th class="right">Amount</th>
    </tr>
    </thead>
    <tbody>
    <tr>
      <td>NYLTA.com Filing<br>
        '.($desc2 ? '<span>'.h($desc2).'</span>' : '').'
      </td>
      <td>'.h($qty).'</td>
      <td>'.money($amount).'</td>
    </tr>
    </tbody>
  </table>
</div>
</body>
</html>
';

$defaultConfig = (new Mpdf\Config\ConfigVariables())->getDefaults();
$fontDirs = $defaultConfig['fontDir'];

$defaultFontConfig = (new Mpdf\Config\FontVariables())->getDefaults();
$fontData = $defaultFontConfig['fontdata'];

// -------- mPDF
$mpdf = new \Mpdf\Mpdf([
    'mode' => 'utf-8',
    'format' => [222.26, 156.10],
    'margin_top' => 0,
    'margin_bottom' => 0,
    'margin_left' => 0,
    'margin_right' => 0,
    'fontDir' => array_merge($fontDirs, [__DIR__ . '/fonts']),
    'fontdata' => $fontData + [
            'poppins' => [
                'R' => 'Poppins-Regular.ttf',
                'B' => 'Poppins-Bold.ttf',
            ],
            'poppinsmedium' => [ // 👈 new font alias
                'R' => 'Poppins-Medium.ttf',
            ],
            'librebaskerville' => [
                'R' => 'LibreBaskerville-Regular.ttf',
                'B' => 'LibreBaskerville-Bold.ttf',
            ],
        ],
    'default_font' => 'poppins',
]);

$mpdf->WriteHTML($html);

// download
$filename = 'Invoice_'.preg_replace('/[^A-Za-z0-9_-]/', '', $name).'_'.date('Ymd').'.pdf';
$mpdf->Output($filename, 'D');